<?php
namespace model;

class Achievement extends \Pawn\Model
{
	// Migration
	public static function migration()
	{
		return array
		(
			array('CREATE', array
			(
				'user_id'		=>	'INT UNSIGNED',
				'game_id'		=>	'INT UNSIGNED',
				
				'name'			=>	'VARCHAR(255)',
				'kind'			=>	'ENUM("leaderboards", "ingame")',
				'description'	=>	'TEXT',
				'thumbnail'		=>	'VARCHAR(255)'
			))
		);
	}
	
	// Validation
	public function columns($preset)
	{
		return array
		(
			'user_id'		=>	array('text', array('c_user_exists'=>array($this, 'user_exists'))),
			'game_id'		=>	array('text', array('c_game_exists'=>array($this, 'game_exists'))),
			
			'name'			=>	array('text', array('optional'=>true)),
			'kind'			=>	array('select', array('leaderboards', 'ingame')),
			'description'	=>	array('textarea', array('optional'=>true)),
			'thumbnail'		=>	array('file', array())
		);
	}
	
	public function user_exists($id)
	{
		return \model\User::num_rows('WHERE id=?', $id, false);
	}
	
	public function game_exists($id)
	{
		return \model\Game::num_rows('WHERE id=?', $id, false);
	}
}